#!/bin/bash
# Apache Tomcat daemon
#
# chkconfig: 345 10 10
# description: Apache Tomcat daemon
#
# processname: tomcat

echo "  ______                           __   "
echo " /_  __/___  ____ ___  _________ _/ /_  "
echo "  / / / __ \/ __  __ \/ ___/ __  / __/  "
echo " / / / /_/ / / / / / / /__/ /_/ / /_    "
echo "/_/  \____/_/ /_/ /_/\___/\__,_/\__/    "
echo "                                        "

#定义JAVA_HOME
export JAVA_HOME=/usr/local/java/jdk1.7.0_80

#定义多个tomcat的总目录，/app/tomcat目录下有node1、node2、node3、node4 四个tomcat实例。
tom="/app/tomcat/node"

#定义启动脚本路径
startup_bin="bin/startup.sh"

#定义tomcat的启动方式，启动方式为tomcat.sh p1 start类似的命令
usage="{p1|p2|p3|all} {start|stop|restart|status}"
dev="/dev/null"

#定义如何启动tomcat，在此我们是通过个数tomcat以及前面定义的tomcat的命令，来操作tomcat
#judge $1 $2 whether null
if [ "$1" == "" -o "$2" == "" ];then
    echo
     echo "Usage: $0 $usage"
    echo
exit 1
fi
#judge $1
case $1 in
   "p1")
    tomcats="1"
;;
   "p2")
    tomcats="1 2"
;;
   "p3")
    tomcats="1 2 3"
;;
   "all")
    tomcats="1 2 3 4"
;;
   *)
   echo "Usage: $0 $usage"
;;
esac

#定义tomcat的启动
#define start function
tomcatstart() {
for i in $tomcats
  do
  tom_home="$tom$i"
  run_status=$(ps -ef | grep -v 'grep' | egrep "java.*=${tom_home}")
if [ "${run_status}X" != "X" ];then
echo "node$i is already running..."
else
${tom_home}/${startup_bin} &>$dev
echo "node$i starting,Please wait 2s..."
sleep 2
fi
done
}
#定义tomcat的关闭
#define stop function
tomcatstop() {
for j in $tomcats
do
tom1_home="$tom$j"
tomcat_pid=$(ps -ef | grep ${tom1_home} | grep "org.apache.catalina.startup.Bootstrap start" | awk '{printf $2}')
if [ "${tomcat_pid}X" == "X" ];then
echo "node$j is not running..."
else
kill -9 ${tomcat_pid} & >$dev
echo "node$j stopping,Please wait 1s..."
sleep 1
echo "delte node$j cache,Please wait 1s..."
rm -rf ${tom1_home}/work/*
fi
done
}

#定义tomcat的重启
#define restart function
tomcatrestart() {
for m in $tomcats
do
tom2_home="$tom$m"
run2_status=$(ps -ef | grep -v 'grep' | egrep "java.*=${tom2_home}")
if [ "${run2_status}X" == "X" ];then
echo "node$m is not running..."
${tom2_home}/${startup_bin} &>$dev
echo "node$m starting,Please wait 2s..."
sleep 2
else
ps -ef | grep ${tom2_home} | grep "org.apache.catalina.startup.Bootstrap start" | awk '{printf $2}'| xargs kill -9 >$dev
echo "node$m stopping,Please wait 2s..."
sleep 1
${tom2_home}/${startup_bin} &>$dev
echo "node$m starting,Please wait 2s..."
sleep 2
fi
done
}

#定义tomcat的状态
#define status function
tomcatstatus() {
for n in $tomcats
do
tom3_home="$tom$n"
run3_status=$(ps -ef | grep -v 'grep' | egrep "java.*=${tom3_home}")
if [ "${run3_status}X" == "X" ];then
echo "node$n is not running..."
else
echo "node$n is running"
fi
done
}

#judge $2
case $2 in
    "start")
    tomcatstart
;;
    "stop")
    tomcatstop
;;
   "restart")
   tomcatrestart
;;
   "status")
   tomcatstatus
;;
   *)
   echo "Usage: $0 $usage"
;;
esac